

<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">Checkout</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Licenses</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<style>
    /* Container for the software grid */
#software-grid {
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
}

/* Individual selectable box */
.software-box {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    width: 108px;
    height: 120px;
    padding: 10px;
    border: 2px solid #ccc;
    border-radius: 8px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
}

/* Hidden radio input */
.software-box input {
    display: none;
}

/* Box content (image + name) */
.software-box .box-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 5px;
}

/* Image styling */
.software-box img {
    max-width: 50px;
    height: auto;
    border-radius: 5px;
}

/* Hover effect */
.software-box:hover {
    border-color: #007bff;
    background-color: #f8f9fa;
}

/* Selected box styling */
.software-box input:checked + .box-content {
    border-color: #007bff;
    font-weight: bold;
    color: #007bff;
}
span {
    height: 26px;
    overflow: hidden;
}
</style>
    <section class="content">
        <?php echo $__env->make('notify.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('notify.success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Order License</h3>
                        </div>
                        <form role="form" method="post" action="<?php echo e(route('license.add')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Select Software:</label>
                                    <div class="d-flex flex-wrap gap-3" id="software-grid">
                                        <?php if($softwares): ?>
                                            <?php $__currentLoopData = $softwares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $software): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <label class="software-box">
                                                    <input type="radio" name="software_id" value="<?php echo e($software->id); ?>"
                                                        key-name="<?php echo e($software->name); ?>">
                                                    <div class="box-content">
                                                        <img src="/path/to/logo.png" alt="<?php echo e($software->name); ?>">
                                                        <span><?php echo e($software->name); ?></span>
                                                    </div>
                                                </label>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <!-- Modal for Buy For -->
                                <div class="modal fade" id="buyForModal" tabindex="-1" role="dialog" aria-labelledby="buyForModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="buyForModalLabel">Add a new license</h5>
                                                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form id="buyForForm" method="post" action="<?php echo e(route('license.add')); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="software_id" id="selectedSoftwareId">
                                                    <div class="form-group">
                                                        <label for="show_month">Select Plan:</label>
                                                        <select class="form-control" name="end_at" id="show_month"></select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="ip">IPv4</label>
                                                        <input type="text" class="form-control" name="ip" id="ip" placeholder="Enter IP address">
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php
                                    $reseller_id = App\Models\Reseller::firstWhere('user_id', Auth::id());
                                ?>
                                <div class="form-group" style="display:none">
                                    <label>Reseller</label>
                                    <select class="form-control" name="reseller">
                                        <option value="<?php echo e($reseller_id->id); ?>"
                                            <?php echo e($reseller_id->reseller_id == $reseller_id->id ? 'selected' : ''); ?>>
                                            <?php echo e($reseller_id->name); ?></option>
                                    </select>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(function () {
        $('#software-grid input[name="software_id"]').change(function () {
            let softwareId = $(this).val();
            $('#selectedSoftwareId').val(softwareId);

            // Fetch the plan details for the selected software
$.ajax({
    url: "/panel/product/price/" + softwareId,
    success: function (data) {
        // Ensure the select element is empty before adding new options
        $('#show_month').html(data);
    },
    error: function (xhr) {
        alert('An error occurred. Please try again.');
    }
});

            // Show the modal
            $('#buyForModal').modal('show');
        });

        // Handle form submission
        $('#buyForForm').on('submit', function (e) {
            e.preventDefault(); // Prevent default form submission
            let formData = $(this).serialize(); // Collect form data

            // Submit the form via AJAX
            $.ajax({
                url: $(this).attr('action'),
                method: "POST",
                data: formData,
                success: function (response) {
                    alert('Form submitted successfully!');
                    $('#buyForModal').modal('hide'); // Close the modal
                },
                error: function (xhr) {
                    alert('An error occurred. Please try again.');
                }
            });
        });
    });

document.addEventListener("DOMContentLoaded", function () {
    // Get the base URL from Laravel's configuration
    const baseUrl = "<?php echo env('APP_URL'); ?>";

    // Mapping of software names to their respective image paths
    const softwareImages = {
        "cPanel VPS": "/dist/img/softwares/cpanel-whm.png",
        "Imunify360": "/dist/img/softwares/Imunify360.png",
        "cPanel Dedicated": "/dist/img/softwares/cpanel-whm.png",
        "LiteSpeed": "/dist/img/softwares/LiteSpeed-.png",
        "CloudLinux": "/dist/img/softwares/CloudLinux-.png",
        "CXS - ConfigServer eXploit Scanner": "/dist/img/softwares/CXS.png",
        "JetBackup": "/dist/img/softwares/JetBackup-.png",
        "WHMReseller": "/dist/img/softwares/WHMReseller-.png",
        "DAReseller": "/dist/img/softwares/DAReseller-.png",
        "WHMSonic": "/dist/img/softwares/WHMSonic-.png",
        "OSM - Outgoing Spam Monitor": "/dist/img/softwares/OSM.png",
        "Softaculous": "/dist/img/softwares/Softaculous.png",
        "Virtualizor": "/dist/img/softwares/Virtualizor.png",
        "SitePad": "/dist/img/softwares/sitepad.png",
        "SYSCare": "/dist/img/softwares/SYSCare-.png",
        "Webuzo V3 Business": "/dist/img/softwares/Webuzo.png",
        "kernelcare": "/dist/img/softwares/kernelcare.png",
        "FleetSSL": "/dist/img/softwares/fleetssl.png",
        "Plesk": "/dist/img/softwares/plesk.png",
        "Virtualizor Pro": "/dist/img/softwares/virtualizor-pro.png",
        "Plesk Dedicated": "/dist/img/softwares/plesk-dedicated.png",
        "WHMCS + Auto Updator": "/dist/img/softwares/WHMCS.png",
        "Linux Malware Detect Manager (LMD)": "/dist/img/softwares/Linux-Malware-Detect-lmd.png",
        "(D)DoS Mitigator (cPanel)": "/dist/img/softwares/DDoS-Mitigator-cPanel.png",
        "cPSheild v5": "/dist/img/softwares/cpShield.png",
        "cPRemote": "/dist/img/softwares/cpremote.png",
        "cPNginx": "/dist/img/softwares/cpnginx-.png",
        "WatchMySQL": "/dist/img/softwares/WatchMySQL-icon.png",
        "WHMXtra": "/dist/img/softwares/WHMXtra.png",
        "CleanBackups - cPanel / WHM plugin": "/dist/img/softwares/CleanBackups.png",
        "Redis Plugin for cPanel": "/dist/img/softwares/Redis-cPanel-Plugin.png",
        "Account DNS Check - cPanel": "/dist/img/softwares/Account-DNS-Check.png",
        "LetsEncrypt SSL": "/dist/img/softwares/lets-encrypt-logo.png",
        "RKHunter Interface": "/dist/img/softwares/rkh_logo_50_cpanel-1.png",
        "APF Firewall Interface": "/dist/img/softwares/APF-Firewall-LicenseDash-Plesk.png",
        "ServerWatch": "/dist/img/softwares/ServerWatch-LicenseDash-Plesk.png",
    };

    // Iterate through each software box and set the image source dynamically
    document.querySelectorAll("#software-grid .software-box").forEach(function (box) {
        const span = box.querySelector("span");
        if (span) {
            const softwareName = span.textContent.trim();
            const img = box.querySelector("img");
            if (img) {
                // Prepend the base URL to the image path or fallback to the default image
                const imagePath = softwareImages[softwareName] ? baseUrl + softwareImages[softwareName] : baseUrl + "/dist/img/logo.webp";
                img.src = imagePath;
                img.alt = softwareName;
            }
        }
    });
});

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/resellercenter/public_html/panel/resources/views/licenses/add.blade.php ENDPATH**/ ?>