<!DOCTYPE html>
<html lang="en">
<!-- 

  _____                _ _            _____           _                                  
 |  __ \              | | |          / ____|         | |                                 
 | |__) |___  ___  ___| | | ___ _ __| |     ___ _ __ | |_ ___ _ __        ___  _ __ __ _ 
 |  _  // _ \/ __|/ _ \ | |/ _ \ '__| |    / _ \ '_ \| __/ _ \ '__|      / _ \| '__/ _` |
 | | \ \  __/\__ \  __/ | |  __/ |  | |___|  __/ | | | ||  __/ |     _  | (_) | | | (_| |
 |_|  \_\___||___/\___|_|_|\___|_|   \_____\___|_| |_|\__\___|_|    (_)  \___/|_|  \__, |
                                                                                    __/ |
                                                                                   |___/ 

-->

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($site_name->value ?? 'ResellerCenter.org'); ?> - Login</title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('dist/img/rc.png')); ?>">

    <!-- Bootstrap CSS -->

    <!-- Font Awesome -->

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet"> <?php echo app('Illuminate\Foundation\Vite')(['public/assets/scss/apps.scss']); ?>
    <!-- Custom CSS -->

    <!-- reCAPTCHA -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
        }
            
               .btn-primary {
            background-color: #2f2f3b !important;
            border-color: var(--theme-deafult) !important;
        }
    </style>
</head>

<body>

    <div class="container-fluid p-0">
        <div class="row m-0">
            <div class="col-12 p-0">
                <div class="login-card">
                    <div>
                        <h1>    <img src="<?php echo e(asset('dist/img/logos.png')); ?>" alt="Logo">
</h1>
                        <p style="display:none;">Powered by LicenseDash</p>
                        <div class="login-main">
                            <h4>Reseller panel login</h4>
                            <!-- Display success message if exists -->
                            <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                            <?php endif; ?>

                            <!-- Display error message if exists -->
                            <?php if(session('error')): ?>
                            <div class="alert alert-danger">
                                <?php echo e(session('error')); ?>

                            </div>
                            <?php endif; ?>

                            <form method="POST" action="<?php echo e(route('login.token')); ?>" class="theme-form">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="token" class="col-form-label mb-4">Your Reseller Token :</label>
                                    <input type="text" class="form-control" name="token" id="token" required>
                                </div>
                        </div>
                        <br>
                        <br>

                        <div class="text-center" bis_skin_checked="1">
                            <button type="submit" class="btn btn-primary btn-block enter-btn">Login</button>

                            <a href="<?php echo e(url('/panel/register')); ?>" style="margin-left: 20px;" class="btn btn-primary btn-block enter-btn" bis_skin_checked="1">Become a Reseller</a>

                            <br>
                            <br>

                            <a class="btn btn-primary btn-block enter-btn" href="<?php echo e(url('/panel/login')); ?>" style="margin-left: 20px; font-weight:bold" bis_skin_checked="1">Login Using Password</a>

                        </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.1/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script src="<?php echo e(asset('assets/js/jquery-3.5.1.min.js')); ?>"></script>
    <!-- Bootstrap js-->
    <script src="<?php echo e(asset('assets/js/bootstrap/bootstrap.bundle.min.js')); ?>"></script>
    <!-- feather icon js-->
    <script src="<?php echo e(asset('assets/js/icons/feather-icon/feather.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/icons/feather-icon/feather-icon.js')); ?>"></script>
    <!-- scrollbar js-->
    <!-- Sidebar jquery-->
    <script src="<?php echo e(asset('assets/js/config.js')); ?>"></script>
    <!-- Plugins JS start-->
    <?php echo $__env->yieldContent('script'); ?>
    <!-- Plugins JS Ends-->
    <!-- Theme js-->
    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
    <!-- Plugin used-->
</body>

</html><?php /**PATH /home/resellercenter/public_html/panel/resources/views/auth/token.blade.php ENDPATH**/ ?>